/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.orderform;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.orderform.WebUtils;
import net.creeperhost.minetogether.orderform.data.AvailableResult;
import net.creeperhost.minetogether.orderform.data.Order;
import net.creeperhost.minetogether.orderform.data.OrderSummary;
import net.creeperhost.minetogether.util.Countries;
import net.creeperhost.minetogether.util.ModPackInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class ServerOrderCallbacks {
    private static final Logger LOGGER = LogManager.getLogger();

    public static AvailableResult getNameAvailable(String name) {
        try {
            String result = WebUtils.getWebResponse("https://www.creeperhost.net/json/availability/" + name);
            JsonElement jElement = new JsonParser().parse(result);
            JsonObject jObject = jElement.getAsJsonObject();
            String status = jObject.getAsJsonPrimitive("status").getAsString();
            boolean statusBool = status.equals("success");
            String message = jObject.getAsJsonPrimitive("message").getAsString();
            return new AvailableResult(statusBool, message);
        }
        catch (Throwable t) {
            LOGGER.error("Unable to check if name available", t);
            return new AvailableResult(false, "unknown");
        }
    }

    public static OrderSummary getSummary(Order order, String promo) {
        if (order.country.isEmpty()) {
            order.country = Countries.getOurCountry();
        }
        if (order.serverLocation.isEmpty()) {
            order.serverLocation = ServerOrderCallbacks.getRecommendedLocation();
        }
        try {
            double discount;
            String version = "0";
            if (!ModPackInfo.getInfo().curseID.isEmpty()) {
                version = ModPackInfo.getInfo().curseID;
            }
            String url = "https://www.creeperhost.net/json/order/mc/" + version + "/recommend/" + order.playerAmount;
            String resp = WebUtils.getWebResponse(url);
            JsonElement jElement = new JsonParser().parse(resp);
            JsonObject jObject = jElement.getAsJsonObject();
            String recommended = jObject.getAsJsonPrimitive("recommended").getAsString();
            if (StringUtils.isNotEmpty((CharSequence)promo) && !promo.equalsIgnoreCase("Insert Promo Code here")) {
                WebUtils.getWebResponse("https://www.creeperhost.net/applyPromo/" + promo);
            }
            String summary = WebUtils.getWebResponse("https://www.creeperhost.net/json/order/" + order.country + "/" + recommended + "/summary");
            jElement = new JsonParser().parse(summary);
            jObject = jElement.getAsJsonObject();
            jObject = jObject.getAsJsonObject("0");
            double preDiscount = jObject.getAsJsonPrimitive("PreDiscount").getAsDouble();
            double subTotal = jObject.getAsJsonPrimitive("Subtotal").getAsDouble();
            try {
                discount = jObject.getAsJsonPrimitive("Discount").getAsDouble();
            }
            catch (Exception e) {
                discount = 0.0;
            }
            double tax = jObject.getAsJsonPrimitive("Tax").getAsDouble();
            if (tax <= 0.0) {
                tax = 0.0;
            }
            double total = jObject.getAsJsonPrimitive("Total").getAsDouble();
            String currency = WebUtils.getWebResponse("https://www.creeperhost.net/json/currency/" + order.country);
            jElement = new JsonParser().parse(currency);
            jObject = jElement.getAsJsonObject();
            String prefix = jObject.getAsJsonPrimitive("prefix").getAsString();
            String suffix = jObject.getAsJsonPrimitive("suffix").getAsString();
            String id = jObject.getAsJsonPrimitive("id").getAsString();
            String product = WebUtils.getWebResponse("https://www.creeperhost.net/json/products/" + recommended);
            jElement = new JsonParser().parse(product);
            jObject = jElement.getAsJsonObject();
            String vpsDisplay = jObject.getAsJsonPrimitive("displayName").getAsString();
            String vpsDescription = jObject.getAsJsonPrimitive("description").getAsString();
            String patternStr = "<li>(.*?)<";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(vpsDescription);
            ArrayList<String> vpsFeatures = new ArrayList<String>();
            while (matcher.find()) {
                String group = matcher.group(1);
                vpsFeatures.add(group);
            }
            ArrayList<String> vpsIncluded = new ArrayList<String>();
            vpsIncluded.add("minetogether.quote.vpsincluded1");
            vpsIncluded.add("minetogether.quote.vpsincluded2");
            vpsIncluded.add("minetogether.quote.vpsincluded3");
            vpsIncluded.add("minetogether.quote.vpsincluded4");
            vpsIncluded.add("minetogether.quote.vpsincluded5");
            vpsIncluded.add("minetogether.quote.vpsincluded6");
            vpsIncluded.add("minetogether.quote.vpsincluded7");
            return new OrderSummary(recommended, vpsDisplay, vpsFeatures, vpsIncluded, preDiscount, subTotal, total, tax, discount, suffix, prefix, id);
        }
        catch (Throwable t) {
            LOGGER.error("Unable to fetch summary", t);
            return null;
        }
    }

    public static String getRecommendedLocation() {
        try {
            String freeGeoIP = WebUtils.getWebResponse("https://www.creeperhost.net/json/datacentre/closest");
            JsonObject jObject = new JsonParser().parse(freeGeoIP).getAsJsonObject();
            jObject = jObject.getAsJsonObject("datacentre");
            return jObject.getAsJsonPrimitive("name").getAsString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static Map<String, String> getRegionMap() {
        Map rawMap = new HashMap();
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            String jsonData = WebUtils.getWebResponse("https://www.creeperhost.net/json/locations");
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Gson g = new Gson();
            JsonElement el = new JsonParser().parse(jsonData);
            rawMap = (Map)g.fromJson(el.getAsJsonObject().get("regionMap"), type);
        }
        catch (Exception e) {
            LOGGER.error("Unable to fetch server locations", (Throwable)e);
        }
        for (Map.Entry entry : rawMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            returnMap.put(key, value);
        }
        return returnMap;
    }

    public static Map<String, String> getDataCentres() throws IOException, URISyntaxException {
        JsonArray array;
        String url = "https://www.creeperhost.net/json/datacentre/closest";
        String resp = WebUtils.getWebResponse(url);
        HashMap<String, String> map = new HashMap<String, String>();
        JsonElement jElement = new JsonParser().parse(resp);
        if (jElement.isJsonObject() && (array = jElement.getAsJsonObject().getAsJsonArray("datacentres")) != null) {
            for (JsonElement serverEl : array) {
                JsonObject object = (JsonObject)serverEl;
                String name = object.get("name").getAsString();
                String distance = object.get("distance").getAsString();
                map.put(name, distance);
            }
            return map;
        }
        return null;
    }

    public static boolean doesEmailExist(final String email) {
        try {
            JsonElement jElement;
            JsonObject jObject;
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/account/exists", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("email", email);
                }
            });
            if (!response.equals("error") && (jObject = (jElement = new JsonParser().parse(response)).getAsJsonObject()).getAsJsonPrimitive("status").getAsString().equals("error")) {
                return false;
            }
        }
        catch (Throwable t) {
            LOGGER.error("Unable to check if email exists", t);
            return false;
        }
        return true;
    }

    public static String doLogin(final String username, final String password) {
        try {
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/account/login", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("email", username);
                    this.put("password", password);
                }
            });
            if (!response.equals("error")) {
                JsonElement jElement = new JsonParser().parse(response);
                JsonObject jObject = jElement.getAsJsonObject();
                if (jObject.getAsJsonPrimitive("status").getAsString().equals("error")) {
                    return jObject.getAsJsonPrimitive("message").getAsString();
                }
                return "success:" + jObject.getAsJsonPrimitive("currency").getAsString() + ":" + jObject.getAsJsonPrimitive("userid").getAsString();
            }
            return "Unknown Error";
        }
        catch (Throwable t) {
            LOGGER.error("Unable to do login", t);
            return "Unknown Error";
        }
    }

    public static String createOrder(final Order order, final String pregen) {
        try {
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/order/" + order.clientID + "/" + order.productID + "/" + order.serverLocation, (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("name", order.name);
                    this.put("swid", ModPackInfo.getInfo().curseID);
                    if (order.pregen) {
                        this.put("pregen", pregen);
                    }
                }
            });
            if (!response.equals("error")) {
                JsonElement jElement = new JsonParser().parse(response);
                JsonObject jObject = jElement.getAsJsonObject();
                if (jObject.getAsJsonPrimitive("status").getAsString().equals("success")) {
                    jObject = jObject.getAsJsonObject("more");
                    return "success:" + jObject.getAsJsonPrimitive("invoiceid").getAsString() + ":" + jObject.getAsJsonPrimitive("orderid").getAsString();
                }
                return jObject.getAsJsonPrimitive("message").getAsString();
            }
            return "Unknown error";
        }
        catch (Throwable t) {
            LOGGER.error("Unable to create order", t);
            return "Unknown error";
        }
    }

    public static String createAccount(final Order order) {
        try {
            String response = WebUtils.postWebResponse("https://www.creeperhost.net/json/account/create", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("servername", order.name);
                    this.put("modpack", ModPackInfo.getInfo().curseID);
                    this.put("email", order.emailAddress);
                    this.put("password", order.password);
                    this.put("fname", order.firstName);
                    this.put("lname", order.lastName);
                    this.put("addr1", order.address);
                    this.put("city", order.city);
                    this.put("tel", order.phone);
                    this.put("county", order.state);
                    this.put("state", order.state);
                    this.put("country", order.country);
                    this.put("pcode", order.zip);
                    this.put("currency", order.currency);
                }
            });
            if (!response.equals("error")) {
                JsonElement jElement = new JsonParser().parse(response);
                JsonObject jObject = jElement.getAsJsonObject();
                if (jObject.getAsJsonPrimitive("status").getAsString().equals("error")) {
                    return jObject.getAsJsonPrimitive("message").getAsString();
                }
                return "success:" + jObject.getAsJsonPrimitive("currency").getAsString() + ":" + jObject.getAsJsonPrimitive("userid").getAsString();
            }
            return "Unknown error";
        }
        catch (Throwable t) {
            LOGGER.error("Unable to create account", t);
            return "Unknown error";
        }
    }

    public static String getPaymentLink(String invoiceID) {
        return "https://billing.creeperhost.net/viewinvoice.php?id=" + invoiceID;
    }

    public static boolean cancelOrder(int orderNum) {
        try {
            String string = WebUtils.getWebResponse("https://www.creeperhost.net/json/order/" + orderNum + "/cancel");
        }
        catch (Throwable t) {
            LOGGER.error("Unable to cancel order", t);
            return false;
        }
        return true;
    }
}

